<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class HelloWorldAPI extends SugarApi
{
	public function registerApiRest()
    {
        return array(
            //GET & POST
            'HelloWorldAPI' => array(
                //request type
                'reqType' => array('GET','POST'),

                //set authentication
                'noLoginRequired' => false,

                //endpoint path will equal Hello/World/{number}
                'path' => array('Hello', 'World', '?'),

                //endpoint variables. to access the last value in the url, we will use "number"
                'pathVars' => array('', '', 'number'),

                //method to call
                'method' => 'CallHelloWorld',

                //short help string to be displayed in the help documentation
                'shortHelp' => '',

                //long help to be displayed in the help documentation
                'longHelp' => '',
            ),
        );
    }
    /**
     * Method to be used for Hello/World/{number} endpoint
     */
    public function CallHelloWorld($api, $args)
    {
        return 'Hello World ' . $args['number'];
    }
}