<?php
require_once 'include/Expressions/Expression/String/StringExpression.php';

class CurrentUserPlatformExpression extends StringExpression
{
    /**
     * Returns the raw platform name used in the current request.
     * Examples: base, mobile, portal, Integration123, etc.
     */
    public function evaluate()
    {
        $platform = null;

        // Preferred: from REST service object
        if (isset($GLOBALS['service'])) {
            if (method_exists($GLOBALS['service'], 'getPlatform')) {
                $platform = $GLOBALS['service']->getPlatform();
            } elseif (property_exists($GLOBALS['service'], 'platform')) {
                $platform = $GLOBALS['service']->platform;
            }
        }

        // Fallbacks for non-REST contexts or integrations
        if (!$platform && !empty($_SERVER['HTTP_X_SUGAR_PLATFORM'])) {
            $platform = $_SERVER['HTTP_X_SUGAR_PLATFORM'];
        }
        if (!$platform && !empty($_SERVER['HTTP_SUGAR_PLATFORM'])) {
            $platform = $_SERVER['HTTP_SUGAR_PLATFORM'];
        }
        if (!$platform && !empty($_SERVER['HTTP_X_SUGAR_CLIENT'])) {
            $platform = $_SERVER['HTTP_X_SUGAR_CLIENT'];
        }
        if (!$platform && !empty($_SERVER['HTTP_SUGAR_CLIENT'])) {
            $platform = $_SERVER['HTTP_SUGAR_CLIENT'];
        }

        // As a last fallback, SugarCRM Mobile app often includes its signature in the User-Agent
        if (
            !$platform &&
            !empty($_SERVER['HTTP_USER_AGENT']) &&
            stripos($_SERVER['HTTP_USER_AGENT'], 'SugarCRM Mobile') !== false
        ) {
            $platform = 'mobile';
        }

        // Default to 'base' if nothing is found
        return trim($platform ?: 'base');
    }

    public static function getJSEvaluate()
    {
        // Client side: used only in Studio previews
        return <<<JS
            return "base";
        JS;
    }

    public static function getOperationName()
    {
        return ['currentUserPlatform'];
    }

    public static function getParameterTypes()
    {
        return [];
    }

    public static function getParamCount()
    {
        return 0;
    }
}
